import argparse
from yt import wrapper as yw
from yt.logger import LOGGER as yt_logger


class SoyTablesMerger:  # mapper
    def __init__(self):
        pass

    def __call__(self, row):
        row['id'] = 't{}r{}'.format(row['@table_index'], row['@row_index'])
        yield row


def main(args):
    if not args.input_paths or len(args.input_paths) == 1 and args.input_paths[0] == args.output_path:
        yt_logger.info('Nothing to merge')
        return
    yw.config['pickling']['python_binary'] = '/skynet/python/bin/python'
    input_paths = sum(
        (yw.search(input_path, ['table']) for input_path in args.input_paths),
        [],
    )
    yt_logger.info('Input paths: {}'.format(', '.join(input_paths)))
    yw.run_map(
        SoyTablesMerger(),
        input_paths,
        args.output_path,
        format=yw.YsonFormat(control_attributes_mode='row_fields'),
        spec={'job_io': {'control_attributes': {'enable_row_index': True, 'enable_table_index': True}}},
    )
    yw.run_sort(args.output_path, sort_by=['id'])


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Build table with requests for SoY')
    parser.add_argument('--output-path', required=True, help='Output table path')
    parser.add_argument('--input-paths', nargs='*', help='Compiled tables')
    main(parser.parse_args())
