# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.types import resource as ctr
import sandbox.projects.resource_types.releasers as rr


class HandlerOutputSlowJsonContexts(sdk2.resource.AbstractResource):
    """
        JSON contexts for HANDLER_OUTPUT_SLOW
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class HandlerOutputJsonContexts(sdk2.resource.AbstractResource):
    """
        JSON contexts for HANDLER_OUTPUT
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class ReportInitAndHeadersJsonContexts(sdk2.resource.AbstractResource):
    """
        JSON contexts for REPORT_INIT_AND_HEADERS
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class InitAndHeadersJsonContexts(sdk2.resource.AbstractResource):
    """
        JSON contexts for INIT_AND_HEADERS
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class BinaryRequestsForNoapacheAdjuster(sdk2.resource.AbstractResource):
    """
        binary requests for noapache adjuster
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class BinaryRequestsForWebSrcSetup(sdk2.resource.AbstractResource):
    """
        binary requests for Web Src Setup
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class BinaryRequestsForWebMisspellSrcSetup(sdk2.resource.AbstractResource):
    """
        binary requests for Web Misspell Src Setup
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class BinaryRequestsForBlender(sdk2.resource.AbstractResource):
    """
        binary requests for Web Misspell Src Setup
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class EntitySearchJsonContexts(sdk2.resource.AbstractResource):
    """
        JSON contexts for ENTITYSEARCH
    """
    auto_backup = True


class YanswerGrpcClientPlan(sdk2.resource.AbstractResource):
    """
        Plan for apphost/tools/grpc_client
    """
    auto_backup = True


class AntiObjectGrpcClientPlan(sdk2.resource.AbstractResource):
    """
        Plan for apphost/tools/grpc_client
    """
    auto_backup = True


class BlenderGrpcClientPlan(sdk2.resource.AbstractResource):
    """
        Plan for apphost/tools/grpc_client
    """
    auto_backup = True


class NoapacheAdjusterResponses(sdk2.resource.AbstractResource):
    """
        responses from /adjust_params
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class NoapacheBlenderResponses(sdk2.resource.AbstractResource):
    """
        responses from blender
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class UpperIntUnpackedResponses(sdk2.resource.AbstractResource):
    """
        responses from blender
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class NoapacheAdjusterUnpackedResponses(sdk2.resource.AbstractResource):
    """
        responses from /adjust_params
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class NoapacheBlenderUnpackedResponses(sdk2.resource.AbstractResource):
    """
        responses from blender
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class REQUEST_SAMPLER_EXECUTABLE(sdk2.resource.AbstractResource):
    """
        search/tools/request_sampler executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rr.search_runtime_devops + ['robot-testenv']
    arcadia_build_path = 'search/tools/request_sampler'
    arcadia_build_name = 'request_sampler'


class APP_HOST_OPS_EXECUTABLE(sdk2.resource.AbstractResource):
    """
        search/tools/app_host_ops executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/tools/app_host_ops'
    arcadia_build_name = 'app_host_ops'


class NoapacheupperInstancectlConf(sdk2.resource.Resource):
    """
        Noapacheupper instancectl.conf file
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/daemons/noapacheupper/instancectl_conf'
    arcadia_build_name = 'noapacheupper_instancectl_conf'


class NoapacheupperPushclientConfTmpl(sdk2.resource.Resource):
    """
        Noapacheupper push-client.conf.tmpl file
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/daemons/noapacheupper/instancectl_conf'
    arcadia_build_name = 'noapacheupper_pushclient_conf_tmpl'


class NoapacheupperUnifiedAgentConfTmpl(sdk2.resource.Resource):
    """
        Noapacheupper unified_agent.conf.tmpl file
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/daemons/noapacheupper/instancectl_conf'
    arcadia_build_name = 'noapacheupper_unified_agent_conf_tmpl'


class NoapacheProductionInstancectlConf(sdk2.resource.Resource):
    """
        Noapacheupper instancectl.conf file for production
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/daemons/noapacheupper/instancectl_conf'
    arcadia_build_name = 'noapache_production_instancectl_conf'
    config_name = 'instancectl_production_fast_data_pushclient.conf'


class NoapacheHamsterInstancectlConf(sdk2.resource.Resource):
    """
        Noapacheupper instancectl.conf file for hamster
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/daemons/noapacheupper/instancectl_conf'
    arcadia_build_name = 'noapache_hamster_instancectl_conf'
    config_name = 'instancectl_hamster_fast_data_pushclient.conf'


class NoapachePushclientProductionConf(sdk2.resource.Resource):
    """
        Noapacheupper pushclient config for production
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/daemons/noapacheupper/instancectl_conf'
    arcadia_build_name = 'noapache_pushclient_production_conf'
    config_name = 'push-client.conf.tmpl'


class NoapachePushclientHamsterConf(sdk2.resource.Resource):
    """
        Noapacheupper pushclient config for hamster
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/daemons/noapacheupper/instancectl_conf'
    arcadia_build_name = 'noapache_pushclient_hamster_conf'
    config_name = 'push-client_hamster.conf.tmpl'


class WebBlenderExecutableFuzzy(sdk2.resource.AbstractResource):
    """
        Fuzzer web blender executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = rr.search_runtime_devops
    arcadia_build_path = 'search/fuzzing/fuzz_blender/fuzz_blender'
    arcadia_build_name = 'blender_fuzzy'


class BlenderNehCache(sdk2.resource.AbstractResource):
    """
        Кеш с результатами ответов от подисточников блендера
        (используется для атономного тестирирования сервиса)
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


class NoapacheupperExecutable(sdk2.resource.AbstractResource):
    """
        Noapache upper
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = rr.noapacheupper_releasers
    release_subscribers = []


class NoapacheUpper(NoapacheupperExecutable):  # for back compatibility
    pass


class UpperUnistatSignals(sdk2.resource.AbstractResource):
    pass


class RearrangeDataFast(sdk2.Resource):
    """
        быстрые данные для верхнего метапоиска
    """
    releasable = True
    auto_backup = True
    releasers = rr.noapacheupper_releasers
    arcadia_build_path = 'search/web/rearrs_upper/rearrange.fast'
    revision = sdk2.Attributes.Integer('Arcadia revision', required=True)
    version = sdk2.Attributes.Integer('Version', required=True)
    vertical = sdk2.Attributes.String('Vertical')


class RearrangeDataFastBundle(sdk2.Resource):
    """
        быстрые данные для верхнего метапоиска
    """
    releasable = True
    auto_backup = True
    releasers = rr.noapacheupper_releasers
    arcadia_build_path = 'search/web/rearrs_upper/rearrange.fast'
    revision = sdk2.Attributes.Integer('Arcadia revision', required=True)
    version = sdk2.Attributes.Integer('Version', required=True)
    vertical = sdk2.Attributes.String('Vertical')


class RearrangeDataFastBundleBlank(sdk2.Resource):
    """
        пустой файл для быстрой активации быстрых данных верхнего метапоиска
    """
    releasable = True
    auto_backup = True
    releasers = rr.noapacheupper_releasers


class FastDataDeployer(sdk2.Resource):
    """
        Бинарь search/tools/fast_data_deployment/deployer
        для деплоя быстрых данных верхнего метапоиска
    """
    executable = True
    releasable = True
    releasers = rr.noapacheupper_releasers


class FastDataCallback(sdk2.Resource):
    """
        Бинарь search/tools/fast_data_deployment/callback
        для деплоя быстрых данных верхнего метапоиска
    """
    executable = True
    releasable = True
    releasers = rr.noapacheupper_releasers


class FastDataBstr(sdk2.Resource):
    """
        Бинарь tools/bstr
        для деплоя быстрых данных верхнего метапоиска
    """
    executable = True
    releasable = True
    releasers = rr.noapacheupper_releasers


class FastDataDeployConfig(sdk2.Resource):
    """
        Конфиг деплоера быстрых данных
    """
    executable = True
    releasable = True
    releasers = rr.noapacheupper_releasers


class RtccBundleNoapache(sdk2.Resource):
    """
        RTCC верхнего метапоиска
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = rr.noapacheupper_releasers


class RtccCacheNoapache(sdk2.Resource):
    """
        RTCC Cache верхнего метапоиска
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = rr.noapacheupper_releasers
