import logging

from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import utils


def import_config(instances, filename):
    for instance in instances:
        try:
            host, port = instance.split(":")
            utils.get_config_by_info_request(host, port, filename)
            return
        except Exception as e:
            logging.warning(str(e))
            continue
    eh.check_failed('Cannot import config')
