# coding: utf-8

import logging

from sandbox.projects.common.nanny import nanny
from sandbox import sdk2
from sandbox.sandboxsdk import environments


class CY_HASH_IKS(sdk2.resource.AbstractResource):
    """
        IKS cy.hash, WMC-5190
    """
    releasable = True
    any_arch = True
    releasers = ["iceflame", "intersection", "kravchenko99", "leonidrom", "lester", "vsedaikina"]


def download_file(yt_client, path, local_path):
    from yt.wrapper.common import chunk_iter_stream, MB
    logging.info("Downloading yt file %r to %r", path, local_path)
    with open(local_path, "wb") as fout:
        for chunk in chunk_iter_stream(yt_client.read_file(path), 16 * MB):
            fout.write(chunk)


class BuildCyHashIKS(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        IKS cy.hash, WMC-5190 (ex BuildCyHash)
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 512

        environments = [
            environments.PipEnvironment('yandex-yt'),
        ]

    class Parameters(sdk2.Task.Parameters):
        mr_server = sdk2.parameters.String("YT proxy", default="arnold.yt.yandex.net")
        skip_test = sdk2.parameters.Bool("Don't test data. I DO KNOW what I'm doing", default=False)
        yt_token_name = sdk2.parameters.String("Name of the sandbox vault record storing yt token", default="robot-webmaster-yt-token")
        yt_token_owner = sdk2.parameters.String("Owner of the sandbox vault record storing yt token", default="WEBMASTER")
        yt_resource_path = sdk2.parameters.String('YT cy.hash path', default='//home/webmaster/prod/iks/cy.hash')

    def test_data(self):
        raise Exception("Tests not implemented yet")

    def on_execute(self):
        from yt.wrapper import YtClient
        yt_token = sdk2.Vault.data(self.Parameters.yt_token_owner, self.Parameters.yt_token_name)
        yt_client = YtClient(proxy=self.Parameters.mr_server, token=yt_token)

        if self.Parameters.skip_test is not True:
            self.test_data()
            logging.info('All tests passed')
        else:
            logging.warning("Flag 'skip_test' is set by releaser, tests skipped")

        download_file(yt_client, self.Parameters.yt_resource_path, "cy.hash")

        resource = CY_HASH_IKS(self, "IKS cy.hash, WMC-5190", "cy.hash", ttl=180)
        data = sdk2.ResourceData(resource)
        data.ready()
