import os

from sandbox import sdk2
from sandbox.sdk2 import svn
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxMavenEnvironment


class Webmaster3Proto(sdk2.Resource):
    releasers = ['shabashoff', 'robot-webmaster']
    releasable = True
    any_arch = True
    platform = 'any'


class BuildWebmaster3Proto(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            SandboxJavaJdkEnvironment('11.0.2'),
            SandboxMavenEnvironment('3.3.9')
        ]

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.String('revision', default=None, description='Arcadia revision')

    def on_execute(self):
        clone_path = unicode(self.path('wmconsolse'))
        svn.Arcadia.checkout('arcadia:/arc/trunk/arcadia/wmconsole/backend/java', clone_path, revision=self.Parameters.svn_revision)

        os.environ['PATH'] = os.environ['PATH']

        with sdk2.helpers.ProcessLog(self, logger="mvn") as pl:
            process = sp.Popen(
                [
                    'mvn',
                    '-Djava.net.preferIPv4Stack=false',
                    '-Djava.net.preferIPv6Addresses=true',
                    '-s', 'settings.xml',
                    '-f', 'webmaster3-proto/external',
                    'clean',
                    'install'
                ],
                cwd=clone_path, stdout=pl.stdout
            )
            process.timeout = 10800
            process.wait()

        resource = Webmaster3Proto(self, "webmaster3-proto-external jar", unicode(self.path('wmconsole/webmaster3-proto/external/target/proto-external-1.0.0-SNAPSHOT.jar')))
        sdk2.ResourceData(resource).ready()
