# coding: utf-8

from sandbox import sdk2

import sandbox.common.types.client as ctc
from sandbox.projects.common.build.YaPackage import RunTestsParameter, RunLongTestsParameter, IgnoreFailTestsParameter
from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.ya_deploy import release_integration


class Webmaster3BuildBaseTask(YaPackage.YaPackage):
    """
        Abstract task to build webmaster projects
    """
    type = 'WEBMASTER3_BUILD_BASE'
    execution_space = 70 * 1024
    required_ram = 10 * 1024
    client_tags = ctc.Tag.Group.LINUX
    input_parameters = [
        YaPackage.parameters.ArcadiaUrl,
        YaPackage.parameters.ArcadiaPatch,
        YaPackage.parameters.UseArcadiaApiFuse,
        YaPackage.parameters.UseArcInsteadOfArcadiaApi,
        # Tests
        YaPackage.TestsBlock,
        RunTestsParameter,
        RunLongTestsParameter,
        IgnoreFailTestsParameter,
    ]

    def get_yp_oauth_token(self):
        return sdk2.yav.Secret('sec-01cxz076mr6668f6r7804bdtk6').data()['yp-token']

    def on_enqueue(self):
        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.TARBALL
        self.ctx[YaPackage.parameters.BuildType.name] = YaPackage.RELEASE
        self.ctx[YaPackage.CompressPackageArchiveParameter.name] = True
        self.ctx[YaPackage.StripBinariesParameter.name] = False
        self.ctx[RunTestsParameter.name] = True
        self.ctx[RunLongTestsParameter.name] = True
        YaPackage.YaPackage.on_enqueue(self)

    def on_execute(self):
        YaPackage.YaPackage.on_execute(self)


class Webmaster3WorkerBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_WORKER_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-worker-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_WORKER"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3StreamerBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_STREAMER_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-streamer-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_STREAMER"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3ViewerBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_VIEWER_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-viewer-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_VIEWER"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3AdminBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_ADMIN_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-admin-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_ADMIN"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3ApiBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_API_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-api-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_API"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3InternalBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_INTERNAL_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-internal-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_INTERNAL"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3ImporterBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_IMPORTER_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-importer-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_IMPORTER"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3ValidatorBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_VALIDATOR_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-validator-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_VALIDATOR"
        Webmaster3BuildBaseTask.on_enqueue(self)


class Webmaster3MonitoringBuildTask(Webmaster3BuildBaseTask):
    type = 'WEBMASTER3_MONITORING_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "wmconsole/backend/java/webmaster3-monitoring-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "WEBMASTER3_MONITORING"
        Webmaster3BuildBaseTask.on_enqueue(self)


class XmlSearchPeriodicBuildTask(Webmaster3BuildBaseTask):
    type = 'XMLSEARCH_PERIODIC_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "xmlsearch/xmlsearch-periodic-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "XMLSEARCH_PERIODIC"
        Webmaster3BuildBaseTask.on_enqueue(self)


class XmlSearchCounterBuildTask(Webmaster3BuildBaseTask):
    type = 'XMLSEARCH_COUNTER_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "xmlsearch/xmlsearch-counter-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "XMLSEARCH_COUNTER"
        Webmaster3BuildBaseTask.on_enqueue(self)


class XmlSearchSupportBuildTask(Webmaster3BuildBaseTask):
    type = 'XMLSEARCH_SUPPORT_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "xmlsearch/xmlsearch-support-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "XMLSEARCH_SUPPORT"
        Webmaster3BuildBaseTask.on_enqueue(self)


class XmlSearchUserBuildTask(Webmaster3BuildBaseTask):
    type = 'XMLSEARCH_USER_BUILD'

    def on_enqueue(self):
        self.ctx[YaPackage.PackagesParameter.name] = "xmlsearch/xmlsearch-user-assembly/src/main/packages/ya-package.json"
        self.ctx[YaPackage.ResourceTypeParameter.name] = "XMLSEARCH_USER"
        Webmaster3BuildBaseTask.on_enqueue(self)
