# -*- coding: utf-8

import shutil
import os

import sandbox.common.types.task as ctt

from sandbox.sdk2 import Task, WaitTask, Resource, ResourceData
from sandbox.projects.common.arcadia import sdk as arcadiasdk
from sandbox.projects.common.constants import ARCADIA_TRUNK_URL
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2

from sandbox.projects.woland.balancer_panels.bin import BuildBalancerPanelsBundle

from sandbox.projects.woland.resources import WOLAND_PANELS, WOLAND_BALANCER_PANELS
from .generators import apphost


class BuildWolandPanelsBundle(ReleaseToNannyTask2, Task):
    class Parameters(Task.Parameters):
        panels_path = 'search/tools/woland/panels'

    def _build_balancer_panels(self):
        subtask_id = BuildBalancerPanelsBundle(
            self,
            description='Child of task {}'.format(self.id),
            create_sub_task=False,
        ).enqueue()
        with self.memoize_stage.wait_for_balancer_panels:
            raise WaitTask(
                subtask_id,
                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
            )

    def _merge_with_balancer_panels(self, local_path):
        resource = Resource[WOLAND_BALANCER_PANELS].find(state='READY').first()
        if not resource:
            return
        balancer_panels_path = str(ResourceData(resource).path)
        balancer_panels_dst = os.path.join(local_path, 'balancer')
        for filename in os.listdir(balancer_panels_path):
            shutil.copy(os.path.join(balancer_panels_path, filename), balancer_panels_dst)

    def on_execute(self):
        with arcadiasdk.mount_arc_path(ARCADIA_TRUNK_URL) as arcadia:
            arcadia_path = os.path.join(arcadia, self.Parameters.panels_path)
            local_path = os.path.join(self.path().as_posix(), 'panels')
            # Workaround to add directory to resource
            shutil.copytree(arcadia_path, local_path)

            # Generate Apphost panels based on graphs configs
            for filepath, filetext in apphost.get_rendered_panels_files(arcadia):
                abs_filepath = os.path.join(local_path, filepath)
                with open(abs_filepath, 'w') as f:
                    f.write(filetext)

        self._build_balancer_panels()
        self._merge_with_balancer_panels(local_path)

        resource = WOLAND_PANELS(self, 'Panels for Woland', local_path)
        resource_data = ResourceData(resource)
        resource_data.ready()
