# -*- coding: utf-8

import os

import sandbox.sdk2 as sdk2

from sandbox.projects.woland.resources import WOLAND_BALANCER_PANELS
from sandbox.projects.woland.balancer_panels import get_rendered_panels_files


class BuildBalancerPanelsBundle(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        balancer_panels_path = 'panels/balancer'
        tasks_resource = None

    def on_save(self):
        self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
            attrs={
                'target': 'arcadia/BuildBalancerPanelsBundle/bin',
                'released': 'stable',
            },
        ).first().id

    def on_execute(self):
        abs_panels_path = os.path.join(self.path().as_posix(), self.Parameters.balancer_panels_path)
        os.makedirs(abs_panels_path)

        for filename, filetext in get_rendered_panels_files():
            abs_filepath = os.path.join(abs_panels_path, filename)
            with open(abs_filepath, 'w') as f:
                f.write(filetext)

        resource = WOLAND_BALANCER_PANELS(self, 'Balancer panels for Woland', abs_panels_path)
        resource_data = sdk2.ResourceData(resource)
        resource_data.ready()
