import yaml
import logging

from copy import deepcopy
from collections import OrderedDict


class WolandPanel():
    _FILE_TEMPLATE = OrderedDict([
        ('hosts', ''),
        ('itype', ''),
        ('ctype', ['prod', 'prestable']),
        ('prj', []),
        ('geo', []),
        ('monitors', []),
    ])

    _SIGNAL_TEMPLATE = OrderedDict([
        ('signal', ''),
        ('caption', ''),
        ('format', ''),
        ('warning', []),
        ('critical', []),
    ])

    def __init__(self, itype, ctype=[], prj=[], geo=[], signals={}, hosts='ASEARCH'):
        self.hosts = hosts
        self.itype = itype
        self.ctype = ctype
        self.prj = prj
        self.geo = geo
        self.signals = signals

    def get_dict(self):
        result = deepcopy(self._FILE_TEMPLATE)
        result['hosts'] = self.hosts
        result['itype'] = self.itype
        result['ctype'] = self.ctype
        result['prj'] = self.prj
        result['geo'] = self.geo
        result['monitors'] = [self._get_signal_dict(**signal_spec) for signal_spec in self.signals]
        return result

    def _get_signal_dict(self, signal, caption, warning, critical, format='%d%%'):
        result = deepcopy(self._SIGNAL_TEMPLATE)
        result['signal'] = signal
        result['caption'] = caption
        result['warning'] = warning
        result['critical'] = critical
        result['format'] = format
        return result

    @staticmethod
    def _dict_representer(dumper, data):
        return dumper.represent_dict(data.items())

    def get_rendered_yaml(self):
        yaml.Dumper.add_representer(OrderedDict, self._dict_representer)
        logging.debug('Collected dict: %s' % self.get_dict())
        return yaml.dump(self.get_dict())
