# -*- coding: utf-8 -*-
import sandbox.common.types.client as ctc
from sandbox import sdk2
from sandbox.projects.common.build.YaMake2 import YA_MAKE_CLIENT_TAGS
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.workplace.resource_types import WardenBinary


class BuildWarden(YaMakeTemplate.YaMakeTemplate):
    """
        Build Warden model binary.
    """
    class Parameters(YaMakeTemplate.get_project_params((WardenBinary, ))):
        kill_timeout = 15 * 60  # 15 min

    class Requirements(sdk2.Task.Requirements):
        client_tags = YA_MAKE_CLIENT_TAGS & ctc.Tag.GENERIC & ~ctc.Tag.Group.OSX
        disk_space = 1024 * 5
