# coding: utf-8

import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.workplace.resource_types import WorkplaceConfigTgz


class WorkplaceConfig(sdk2.Task):
    """ Make archive with configs and templates """

    def on_execute(self):
        arcadia_path = "arcadia:/arc/trunk/arcadia/search/mon/workplace"
        path = "."
        Arcadia.export(arcadia_path, path)

        # Archive file
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("tar")) as pl:
            sp.Popen("tar -cf configs.tgz configs templates", shell=True, stdout=pl.stdout,
                     stderr=sp.STDOUT).wait()

        # Create resource
        sdk2.ResourceData(WorkplaceConfigTgz(
            self, "Output file", "configs.tgz"
        ))
