# coding: utf-8

from sandbox import sdk2

from sandbox.projects.resource_types.releasers import marty


workplace_releasers = ['lebedev-aa', 'robot-srch-releaser', 'pufit', 'vangr', 'robot-morty']


class WorkplaceResource(sdk2.Resource):
    """
    Abstract Workplace resource.
    """
    releasable = True
    any_arch = False
    releasers = marty + workplace_releasers
    auto_backup = True


class WorkplaceEntrypoint(WorkplaceResource):
    """
    Workplace duty shift binary.
    """
    arcadia_build_path = 'search/mon/workplace/bin'


class WorkplaceUIBundle(WorkplaceResource):
    """
    Transpiled, minimized and archived files for Workplace UI.
    """


class WorkplaceConfigTgz(WorkplaceResource):
    """
    Tar file with configs and templates files inside
    """
    any_arch = True
    auto_backup = False
    executable = False


class WardenBinary(WorkplaceResource):
    """
    Warden service executable
    """
    releasable = True
    arcadia_build_path = 'search/mon/warden/bin/warden'
