""" Constants and jobs for release machine """
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_triggers
import sandbox.projects.release_machine.components.job_graph.stages.job_graph_element as jg_element
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const, releasable_items as ri

# constants
RESPONSIBLE = configs.Responsible(
    abc=configs.Abc(component_id=1353, role_id=1935),
    login="inngonch",
)
TRUNK_TASK_OWNER = "ANTIFRAUD"
TESTENV_DB_OWNERS = [
    "biwboris0",
    "inngonch",
    "mesteno",
    "noxandry",
    "the-roman",
]
STARTREK_QUEUE = "AFRELEASE"
STARTREK_ASSIGNEE = "robot-antifraud"
STARTREK_WORKFLOW = {
    "production": "close",
}
WIKI_PAGE_OWNER = "robot-antifraud"


# jobs
class JobGraphElementChangelogProcessor(jg_element.JobGraphElement):
    def __init__(self, job_params=None, job_arrows=(), ctx=None):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "job_type": "CHANGELOG_PROCESSOR",
                "task_name": "XURMA_PREPARE_CHANGELOG",
                "should_add_to_db": jg_utils.should_add_to_db_trunk,
                "ctx": ctx,
                "out": {
                    "RELEASE_MACHINE_CHANGELOG": 30,
                },
            },
        )
        super(JobGraphElementChangelogProcessor, self).__init__(
            job_params=merged_job_params,
            job_arrows=job_arrows,
        )
        self.job_arrows += (
            jg_triggers.JobTriggerChangelog([
                jg_data.ParentDataResource("original_changelog", "RELEASE_MACHINE_CHANGELOG"),
            ]),
        )


class JobGraphElementAgreementMaker(jg_element.JobGraphElement):
    def __init__(self, job_name_parameter, job_params=None, job_arrows=(), ctx=None):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "job_type": "AGREEMENT_MAKER",
                "task_name": "XURMA_ADD_AGREEMENT",
                "should_add_to_db": jg_utils.should_add_to_db_branch,
                "ctx": ctx,
            },
        )
        super(JobGraphElementAgreementMaker, self).__init__(
            job_params=merged_job_params,
            job_arrows=job_arrows,
        )
        self.job_arrows += (
            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
        )


def ya_deploy_stage(service, stage=rm_const.ReleaseStatus.stable):
    return ri.YaDeployInfo(ri.DeployService(service), stage=stage)


def merge_dicts(*dcts):
    result = {}
    for dct in dcts:
        result.update(dct)
    return result
