# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxStringParameter, Container
from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.constants import SANDBOX_CONTAINER
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.xurma.resources import XurmaViewer


class PackagesParameter(SandboxStringParameter):
    name = 'packages'
    description = 'Package path'
    required = True


class ContainerParameter(Container):
    name = SANDBOX_CONTAINER
    description = 'Container the task should execute in'
    default_value = 773239891
    required = True


class XurmaBuildViewer(YaPackage.YaPackage):
    """
        Task to create and push xurma viewer docker package
    """
    type = 'XURMA_BUILD_VIEWER'
    execution_space = 50 * 1024
    required_ram = 10 * 1024

    input_parameters = [
        YaPackage.parameters.ArcadiaUrl,
        YaPackage.parameters.BuildType,
        ContainerParameter,

        # Package
        YaPackage.PackagesBlock,
        PackagesParameter,
    ]

    def on_enqueue(self):
        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.DOCKER
        self.ctx[YaPackage.ResourceTypeParameter.name] = XurmaViewer.name
        self.ctx[YaPackage.CompressPackageArchiveParameter.name] = True
        self.ctx[YaPackage.DockerPushImageParameter.name] = True
        self.ctx[YaPackage.DockerBuildNetwork.name] = 'host'
        self.ctx[YaPackage.DockerRegistryParameter.name] = 'registry.yandex.net'
        self.ctx[YaPackage.DockerImageRepositoryParameter.name] = 'antifraud'
        self.ctx[YaPackage.DockerUserParameter.name] = 'robot-antifraud'
        self.ctx[YaPackage.DockerTokenVaultName.name] = 'robot-antifraud-docker-token'
        self.ctx[release_integration.YpTokenVaultParameter.name] = 'robot-antifraud-yp-token'
        self.ctx[release_integration.ReleaseToYaDeployParameter.name] = True
        YaPackage.YaPackage.on_enqueue(self)


__Task__ = XurmaBuildViewer
