# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.types import client as ctc

from sandbox.projects.common import constants, task_env
from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.common.build.ya_package_config import consts as ya_package_consts
from sandbox.projects.common.build.YaPackage2 import YaPackage2
from sandbox.projects.common.ya_deploy import release_integration

from sandbox.projects.antifraud.tasks import set_tests_info_and_get_brief

SB_VAULT_ROBOT_ANTIFRAUD_TOKEN_OWNER = "ANTIFRAUD"
SB_VAULT_ROBOT_ANTIFRAUD_YT_TOKEN_NAME = "robot-antifraud-yt-token"
SB_VAULT_ROBOT_ANTIFRAUD_YP_TOKEN_NAME = "robot-antifraud-yp-token"


class XurmaYtStoreParameters(build_parameters.YtStoreParameters):
    ya_yt_token_vault_owner = build_parameters.YtTokenVaultOwner(default_value=SB_VAULT_ROBOT_ANTIFRAUD_TOKEN_OWNER)
    ya_yt_token_vault_name = build_parameters.YtTokenVaultName(default_value=SB_VAULT_ROBOT_ANTIFRAUD_YT_TOKEN_NAME)


class XurmaBuildBaseTask(YaPackage2):

    class Requirements(task_env.BuildRequirements):
        disk_space = 120 * 1024  # 120 Gb
        client_tags = (ctc.Tag.MULTISLOT | ctc.Tag.GENERIC) & ctc.Tag.SSD & ctc.Tag.Group.LINUX

    class Parameters(YaPackage2.Parameters):
        build_type = build_parameters.BuildType(default_value=constants.RELEASE_BUILD_TYPE)
        strip_binaries = build_parameters.StripBinaries2(default_value=False)

        package_type = build_parameters.PackageType(default_value=ya_package_consts.PackageType.TARBALL.value)
        compress_package_archive = build_parameters.CompressPackageArchive(default_value=True)

        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)

        run_tests = build_parameters.RunTests(default_value=True)
        run_medium_tests = build_parameters.RunMediumTests(default_value=True)
        run_long_tests = build_parameters.RunLongTests(default_value=True)
        ignore_fail_tests = build_parameters.IgnoreFailTests(default_value=True)

        release_to_ya_deploy = release_integration.ReleaseToYaDeployParameter2(default_value=True)
        yp_token_vault = release_integration.YpTokenVaultParameter2(default_value=SB_VAULT_ROBOT_ANTIFRAUD_YP_TOKEN_NAME)

        yt_store_parameters = XurmaYtStoreParameters()

    def on_execute(self):
        super(XurmaBuildBaseTask, self).on_execute()
        tests_brief = set_tests_info_and_get_brief(self, "junit*.xml")
        self.Parameters.description = "<br><br>".join([self.Parameters.description, tests_brief])

    def on_release(self, additional_parameters):
        super(XurmaBuildBaseTask, self).on_release(additional_parameters)
        released_attr = "released_{}".format(additional_parameters["release_status"].lower())
        # Limit 0 means unlimited, because actually there are only a couple of them
        for resource in sdk2.Resource.find(task=self).limit(0):
            if resource.type.releasable:
                resource.ttl = 555  # ~ 1.5 years
                setattr(resource, released_attr, 1)
