from abc import ABC, abstractmethod


class QueryResultBase(ABC):

    def __init__(self) -> None:
        super().__init__()
        self._columns = []
        self._rows = []
        self.query_url = ''

    def get_result_columns(self) -> list:
        return self._columns

    @abstractmethod
    def get_next_row(self) -> list:
        ...

    def is_next_row(self) -> bool:
        if self._rows:
            return True
        else:
            return False


class YQLQueryResult(QueryResultBase):

    def __init__(self, query_result, query_url) -> None:
        super().__init__()

        self.query_url = query_url

        for result in query_result:
            if result.fetch_full_data():
                self._columns = result.column_names
                self._rows = result.rows

    def get_next_row(self) -> list:
        return self._rows.pop()


class ClickHouseOverYTQueryResult(QueryResultBase):

    def __init__(self, query_result) -> None:
        super().__init__()

        if query_result:
            for column_name in query_result[0]:
                self._columns.append(column_name)

            self._rows = query_result

    def get_next_row(self) -> list:
        current_row = self._rows.pop()
        return list(current_row.values())
