import os
from argparse import ArgumentParser
from datetime import datetime, timedelta
from library.python import resource
import json
from sandbox.projects.yabs.AnomalyAuditReport.lib.anomaly_audit import AnomalyAudit


def main(**kwargs):

    print("Anomaly Audit Report starts working")

    parser = ArgumentParser()
    parser.add_argument("--config-path", dest="config_path", help="Path to JSON Config File")
    parser.add_argument("--current-date", dest="current_date", help="Current Date in forman YYYY-MM-DD")
    parser.add_argument("--previous-date", dest="previous_date", help="Date to Compare in forman YYYY-MM-DD")
    parser.add_argument("--yql-token", dest="yql_token", help="YQL Token")
    parser.add_argument("--load-dictionaries", dest="load_dictionaries",
                        help="Load Column Value Descriptions", default=False, type=bool)
    args = parser.parse_args()
    print(args)

    if not args.current_date:
        current_date = (datetime.now() + timedelta(days=-1)).strftime("%Y-%m-%dT%H:00:00")
    else:
        datetime.fromisoformat(args.current_date)
        current_date = args.current_date

    if not args.previous_date:
        previous_date = (datetime.now() + timedelta(days=-8)).strftime("%Y-%m-%dT%H:00:00")
    else:
        datetime.fromisoformat(args.current_date)
        previous_date = args.previous_date

    if not args.yql_token:
        yql_token = os.environ.get('YQL_TOKEN')
    else:
        yql_token = args.yql_token

    if args.config_path is None:
        resource_content = resource.find(
            'sandbox/projects/yabs/AnomalyAuditReport/local_runner/config_for_local_run.json')
        if resource_content is None:
            raise ValueError('Resource query_builder_test_results.yaml is not found')

        report_configs = json.loads(resource_content)
    else:
        with open(args.config_path, 'r') as f:
            report_configs = json.loads(f.read())

    result, errors = AnomalyAudit.create_anomaly_audit_report(current_date, previous_date,
                                                              report_configs,
                                                              yql_token,
                                                              load_column_dictionaries=args.load_dictionaries
                                                              )

    for report_container in result:
        if report_container.has_result():
            print(report_container.get_result())

    for error in errors:
        print(error)

    print("Anomaly Audit Report finished the job")
