from sandbox import sdk2
import sandbox.common.types.client as ctc
import subprocess


class CpuUsageMonitoring(sdk2.Task):
    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.GENERIC & ~ctc.Tag.LXC

    class Parameters(sdk2.Task.Parameters):
        binary_starter = sdk2.parameters.Resource('Binary file')
        solomon_project = sdk2.parameters.String(
            label="Solomon project",
            default="yabs",
            required=True,
        )
        solomon_cluster = sdk2.parameters.String(
            label="Solomon cluster",
            default="yabs",
            required=True,
        )
        solomon_service = sdk2.parameters.String(
            label="Solomon service",
            default="cpu_monitoring",
            required=True,
        )

    def on_execute(self):
        binary_starter = str(sdk2.ResourceData(self.Parameters.binary_starter).path)
        cmd = [
            binary_starter,
            '--solomon_project={0}'.format(self.Parameters.solomon_project),
            '--solomon_cluster={0}'.format(self.Parameters.solomon_cluster),
            '--solomon_service={0}'.format(self.Parameters.solomon_service),
        ]
        subprocess.Popen(cmd).wait()
