from collections import defaultdict
from pathlib import PurePath
from typing import Dict, Iterable, Union

from sandbox.projects.yabs.LogBuildTimes.parse_evlog import Node, BuildNode, BuildOperationNode


def build_graph(lines: Iterable[str]):
    uid_dict = defaultdict(list)
    path_dict = {}
    graph: Dict[PurePath, Union[Node, BuildNode]] = defaultdict(Node)
    for s in lines:
        BuildOperationNode(s, uid_dict, path_dict)
    print(len(path_dict), len(uid_dict))
    for path, nodes in path_dict.items():
        graph[path] = BuildNode(path_dict[path], uid_dict[path])
    for path, build_node in list(graph.items()):
        node = graph[path]
        while path != (path := path.parent):
            graph[path].len_seconds += node.len_seconds
    return graph
