import json
import logging
import re

import yt.wrapper as ytw
from pathlib import PurePath

from sandbox.projects.yabs.LogBuildTimes.graph import build_graph


def get_svn_revision(evlog_path):
    with open(evlog_path) as f:
        for line in f:
            if "svn_revision" not in line:
                continue
            return json.loads(line)["value"]["value"]


def save_yt_report(evlog_path: PurePath, yt_path, yt_token):
    with open(evlog_path) as f:
        graph = build_graph(filter(lambda s: re.search(r'"name":"[^"]*\(', s) and re.search("node-finished", s) and not re.search(r"Pattern", s), f))
    rev = get_svn_revision(evlog_path)
    table = []
    logging.warning(f"Len {len(graph)}")
    for path, node in graph.items():
        table.append({"path": str(path), "len": node.len_seconds})
    ytw.config["proxy"]["url"] = "hahn"  # pylint: disable=unsupported-assignment-operation # noqa
    ytw.config["token"] = yt_token  # pylint: disable=unsupported-assignment-operation # noqa
    ytw.write_table(f"{yt_path}/r{rev}-{evlog_path.name}", table)
