from sandbox import sdk2
from sandbox.sandboxsdk import environments
from routines import get_top_pages, insert_rows


class YabsPCodeDictsRoutines(sdk2.Task):
    """Task That Gathers And Saves 1000 Popular Pages"""
    class Parameters(sdk2.Task.Parameters):
        cluster_names = sdk2.parameters.List(
            "Cluster names"
        )

        destination_path_prefix = sdk2.parameters.String(
            label="destination path prefix",
            default="//home/yabs/dict/",
            required=True
        )

        yql_token_vault_name = sdk2.parameters.String(
            label="YQL token vault name",
            required=True,
        )

        yt_token_vault_name = sdk2.parameters.String(
            label="YT token vault name",
            required=True,
        )

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt', '0.7.38.post0'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet', '0.3.7.post1'),
            environments.PipEnvironment('yql')
        )

    def on_execute(self):
        input_stream = get_top_pages(
            yql_token=sdk2.Vault.data(self.Parameters.yql_token_vault_name)
        )
        for cluster_name in self.Parameters.cluster_names:
            insert_rows(
                proxy=cluster_name,
                yt_token=sdk2.Vault.data(self.Parameters.yt_token_vault_name),
                path_prefix='//home/yabs/dict',
                input_stream=input_stream
            )


__TASK__ = YabsPCodeDictsRoutines
