class YqlIterator(object):
    def __init__(self, client, cluster, query):
        self.client = client
        self.cluster = cluster
        self.query = query

    def __run__(self):
        self.client.config.progress_on_stderr = False
        request = self.client.query(self.query)
        request.run()
        return request.get_results()

    @staticmethod
    def yql_row_to_dict(row, columns):
        return dict(zip(columns, row))

    def __iter__(self):
        for table in self.__run__():
            try:
                table.raw_refs[0]["Reference"][1] = self.cluster
            except (KeyError, IndexError):
                pass
            for row in table.get_iterator():
                yield self.yql_row_to_dict(row, table.column_names)
