from subprocess import Popen, PIPE
import logging

from json import dumps, loads


class Binary(object):
    def __init__(self, binary_path, yt_token, proxy, contour):
        logging.basicConfig(
            level=logging.INFO
        )

        self.binary_path = binary_path
        self.yt_token = yt_token
        self.proxy = proxy
        self.contour = contour

    def launch(self, public_args, stdin=''):
        default_args = [
            '--yql-token',
            self.yt_token,
            '--proxy',
            self.proxy,
            '--contour',
            self.contour
        ]
        if stdin:
            logging.info('binary input: %s', stdin)

        args = [self.binary_path] + list(public_args) + default_args
        logging.info('launch binary with args: {}'.format(public_args))
        p = Popen(
            args,
            stdin=PIPE, stdout=PIPE, stderr=PIPE
        )
        out, err = p.communicate(stdin)
        status = p.returncode

        if out:
            logging.info('binary output: %s', out)
        if err:
            logging.info('binary error: %s', err)
        logging.info('binary return status: %s', status)

        return status, out

    def coordinate(self, failed_operations, finished_operations, st_token):
        status, out = self.launch(
            public_args=['coordinate', '--failed-operations', dumps(failed_operations),
                         '--finished-operations', dumps(finished_operations),
                         '--st-token', st_token],
        )
        assert status == 0
        actions, time_literal = loads(out)
        return actions, time_literal

    def list(self):
        status, out = self.launch(
            public_args=['list']
        )
        assert status == 0
        items = loads(out)
        return items
