from sandbox import sdk2
import logging
from sandbox import common


def get_binary_path():
    resource = sdk2.Resource.find(
        attrs=dict(resource_name="yabs-pcode-slow-statistics-coordinator")
    ).order(-sdk2.Resource.id).first()

    if resource:
        logging.info("Got resource %i" % resource.id)
        return str(sdk2.ResourceData(resource).path)
    else:
        raise common.errors.TaskError("Binary resource does not exist")
