# -*- coding: utf-8 -*-
import json
import logging
import datetime

import jinja2

from sandbox import sdk2
from sandbox.sdk2 import Task, Resource
from sandbox.sdk2.helpers import subprocess as sp

from plotter import PerformancePlotter
from plotter import get_release_revisions
from plot_recipes import recipes


def PlotData(plot_data):
    data = dict()
    data["points"] = zip(plot_data["x"], [100 * val - 100 for val in plot_data["y"]])
    if "switches" in plot_data:
        data["switches"] = list(plot_data["switches"])
    return data


class PerformancePlotResource(Resource):
    """Plot of the worst rps diff since last revision."""
    pass


class PerformancePlotterTask(Task):
    """Plot performance difference from base revision."""

    JINJA_TEMPLATE_RESOURCE_ID = 672425338

    class Requirements(Task.Requirements):
        disk_space = 1024

    def on_execute(self):
        plotter = PerformancePlotter(recipes)

        data_list = plotter.get_plots_data()
        rps_data = PlotData(data_list[0])
        size_data = PlotData(data_list[1])
        bs_a = PlotData(data_list[2])
        bs_b = PlotData(data_list[3])
        bs_c = PlotData(data_list[4])
        yabs_a = PlotData(data_list[5])
        yabs_b = PlotData(data_list[6])
        yabs_c = PlotData(data_list[7])
        bsrank_a = PlotData(data_list[8])
        bsrank_b = PlotData(data_list[9])
        bsrank_c = PlotData(data_list[10])
        size_a = PlotData(data_list[11])
        size_b = PlotData(data_list[12])
        size_c = PlotData(data_list[13])
        bs_avg = PlotData(data_list[14])
        yabs_avg = PlotData(data_list[15])
        bsrank_avg = PlotData(data_list[16])
        rps_avg = PlotData(data_list[17])
        bs_avg_new = PlotData(data_list[18])
        yabs_avg_new = PlotData(data_list[19])
        bsrank_avg_new = PlotData(data_list[20])
        total_avg_weighted_new = PlotData(data_list[21])

        release_revisions = get_release_revisions()

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("du_h")) as pl:
            sp.Popen("sky get sbr:{}".format(self.JINJA_TEMPLATE_RESOURCE_ID),
                     shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()

        resource = PerformancePlotResource(self, "Performance plot", "plot.html")

        loader = jinja2.FileSystemLoader("./")
        env = jinja2.Environment(loader=loader)
        template = env.get_template('plot.tmpl')
        context = {
            "rps": json.dumps(rps_data),
            "size": json.dumps(size_data),
            "bs_a": json.dumps(bs_a),
            "bs_b": json.dumps(bs_b),
            "bs_c": json.dumps(bs_c),
            "yabs_a": json.dumps(yabs_a),
            "yabs_b": json.dumps(yabs_b),
            "yabs_c": json.dumps(yabs_c),
            "bsrank_a": json.dumps(bsrank_a),
            "bsrank_b": json.dumps(bsrank_b),
            "bsrank_c": json.dumps(bsrank_c),
            "size_a": json.dumps(size_a),
            "size_b": json.dumps(size_b),
            "size_c": json.dumps(size_c),
            "bs_avg": json.dumps(bs_avg),
            "yabs_avg": json.dumps(yabs_avg),
            "bsrank_avg": json.dumps(bsrank_avg),
            "rps_avg": json.dumps(rps_avg),
            "release_revisions": json.dumps(release_revisions),
            "time": str(datetime.datetime.now()),
            "bs_avg_new": json.dumps(bs_avg_new),
            "yabs_avg_new": json.dumps(yabs_avg_new),
            "bsrank_avg_new": json.dumps(bsrank_avg_new),
            "total_avg_weighted_new": json.dumps(total_avg_weighted_new),
        }
        html_utf = template.render(context)
        resource.path.write_bytes(html_utf.encode("utf-8"))
