import textwrap
from jinja2 import Environment
from datetime import datetime


FAVICON = textwrap.dedent(u"""\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""")


STYLE = textwrap.dedent(u"""\
    body {
        color: #f2f2f2;
        background-color: #121212;
        font-family: "Lucida Sans Unicode", "Lucida Grande", Sans-Serif, serif;
    }
    a {
        color: #f2f2f2;
        padding: 4px 8px;
    }
    a.version {
        display: block;
    }
    a:visited {
        color: #f2f2f2;
    }
    a:hover {
        background-color: #c2c2c2;
        color: #121212;
    }
    a.stable {
        color: #121212;
        background-color: #00b310;
    }
    a.stable:hover {
        background-color: #c2c2c2;
        color: #121212;
    }
    a.testing {
        color: #121212;
        background-color: #ffed00;
    }
    a.testing:hover {
        background-color: #c2c2c2;
        color: #121212;
    }
    table {
        border-collapse: collapse;
        font-size: x-large;
    }
    th, td {
        padding: 8px 20px;
    }
    th {
        text-align: left;
        vertical-align: top;
        background-color: #323232;
    }
    tr {
        text-align: left;
        vertical-align: top;
    }
    td {
        text-align: left;
        vertical-align: top;
    }
    td.footer {
        text-align: right;
    }
    tr:nth-child(even) {
        background-color: #323232;
    }
""")

REPORT_TEMPLATE = textwrap.dedent(u"""\
<html>
    <head>
        <title>CS versions</title>
        <link href="data:image/x-icon;base64,{{ favicon_base64 }}" rel="icon" type="image/x-icon"/>
        <style>
        {{ style }}
        </style>
    </head>
    <body>
        <table>
            <thead>
                <tr>
                    <th>Instance</th>
                    <th>Description</th>
                    <th>Links</th>
                    <th>Package</th>
                </tr>
            </thead>
            <tbody>
                {% for row in rows -%}
                <tr>
                    <td>{{ row.project }}_{{ row.namespace }}</td>
                    <td>{{ row.description }}</td>
                    <td>
                        <a href="https://{{ row.project }}{{ row.namespace }}.n.yandex-team.ru" target="_blank">Controller</a>
                        <a href="https://dashboard-{{ row.project }}{{ row.namespace }}.n.yandex-team.ru" target="_blank">Dashboard</a>
                    </td>
                    <td><a class="version {{ row.resource.state }}" href="{{ row.resource.link }}" target="_blank">{{ row.resource.version }} [{{ row.resource.state }}]</a></td>
                </tr>
                {% endfor -%}
            </tbody>
            <tfoot>
                <tr>
                    <td class="footer" colspan=3>Updated <a href="{{ task_link }}" target="_blank">{{ update_time }}</a></td>
                </tr>
            </tfoot>
        </table>
    </body>
</html>
""")


def create_report(rows, task_link):
    env = Environment()
    template = env.from_string(REPORT_TEMPLATE)
    update_time = str(datetime.now())
    return template.render(rows=rows, task_link=task_link, update_time=update_time, style=STYLE, favicon_base64=FAVICON)
