# -*- coding: utf-8 -*-

import json
import logging
import requests


class ABCClient(object):
    def __init__(self, token, id_list):
        self._token = token
        self._id_list = id_list

    def get_abc_members(self):
        if not self._id_list or not self._token:
            return set()

        result = set()
        for abc_id in self._id_list:
            url = 'https://abc-back.yandex-team.ru/api/v4/services/members/?service={}&fields=person'.format(abc_id)
            headers = {'Authorization': 'OAuth {}'.format(self._token)}
            response = requests.get(url, headers=headers)
            logging.info('Request to ABC: code={}, url={}'.format(response.status_code, url))
            logging.debug('Request to ABC, text:\n{}'.format(response.text))
            try:
                json_data = response.json()
                logging.debug(json.dumps(json_data, indent=2))
                result |= set(member['person']['login'] for member in json_data['results'])
            except Exception as e:
                raise Exception('Request to ABC failed with exception {}: code={}, url={}, text:\n{}'.format(
                    e, response.status_code, response.url, response.text))

        if not result:
            raise Exception('abc_members is empty')

        return result
