import logging
import re

from sandbox.sdk2.vcs import svn
from sandbox.projects.yabs.SysConstLifetime.lib.utils import checkout


class ArcadiaHelper:
    def __init__(self, arcadia_client, ssh_client, commit_user, commit_user_ssh_vault_key, logger=logging.getLogger(__name__)):
        self._arcadia_client = arcadia_client
        self._ssh_client = ssh_client
        self._commit_user = commit_user
        self._ssh_vault_key = commit_user_ssh_vault_key
        self._logger = logger

    def get_commit_user(self):
        return self._commit_user

    def checkout(self, path):
        return checkout(path, self._arcadia_client, self._logger)

    def commit(self, paths, commit_message, revprop=[], no_tests=False):
        """
        Commits path, in this case only used with single file, path is from the file system.
        """
        from sandbox.projects.yabs.SysConstLifetime.const_proto.const_proto_helper import CommitError

        self._logger.info('Commit changes')
        try:
            with self._ssh_client.Key(self, key_owner=self._commit_user, key_name=self._ssh_vault_key):
                with_revprop = (['arcanum:check-skip=yes'] if no_tests else ['arcanum:review-automerge=yes']) + revprop
                self._logger.info("ARC REP PROPERTY : ", with_revprop)
                stdout = self._arcadia_client.commit(path=paths, message=commit_message, user=self._commit_user, with_revprop=with_revprop)
                self._logger.info("Arcadia client commit stdout: {}".format(stdout))
                revision_match = re.search(r'^Committed revision (\d+).$', stdout, re.MULTILINE)
                try:
                    return 'https://a.yandex-team.ru/arc/commit/' + revision_match.group(1)
                except (AttributeError, IndexError) as e:
                    return None
        except svn.SvnError as e:
            match = re.search(r'^https:\/\/a\.yandex-team\.ru\/review\/\d+$', str(e), re.MULTILINE)
            try:
                return match.group(0)
            except:
                raise CommitError(e)
