import os
import shutil


class FilePipe:
    def __init__(self, path, read_mode='r', write_mode='w'):
        self._path = path
        self._tmp_path = path + '.tmp'
        self._read_mode = read_mode
        self._write_mode = write_mode
        self.in_io = None
        self.out_io = None

    def __enter__(self):
        self.in_io = open(self._path, self._read_mode)
        self.in_io.__enter__()
        self.out_io = open(self._tmp_path, self._write_mode)
        self.out_io.__enter__()
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        self.out_io.__exit__()
        self.in_io.__exit__()

        shutil.copymode(self._path, self._tmp_path)
        os.remove(self._path)
        shutil.move(self._tmp_path, self._path)
