from sandbox import sdk2
import subprocess


class YabsAlertGenerator(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        alert_creator = sdk2.parameters.Resource('Alert creator binary')
        debug = sdk2.parameters.Bool('Debug logging')
        apply_changes = sdk2.parameters.Bool('Apply changes')
        run_daemon = sdk2.parameters.Bool('Run daemon')

    def on_execute(self):
        alert_creator = str(sdk2.ResourceData(self.Parameters.alert_creator).path)
        command = [alert_creator]
        if self.Parameters.debug:
            command.append('--debug')
        if self.Parameters.apply_changes:
            command.append('--apply_changes')
        if self.Parameters.run_daemon:
            command.append('--run_daemon')
        command.extend(["--solomon-token", sdk2.Vault.data('yabs-solo-solomon-token')])
        subprocess.Popen(command).wait()
