from sandbox.projects.common.testenv_client import TEClient
from sandbox.projects.common.testenv_client.api_client import TestenvApiClient
from sandbox import sdk2
import logging
import re
from sandbox.common.errors import TaskFailure
from sandbox.projects.yabs.qa.tasks.YabsBinarySearchHelper import YabsBinarySearchHelper
from sandbox.projects.yabs.qa.utils.general import get_task_html_hyperlink

logger = logging.getLogger(__name__)


class YabsBinarySearchHelperScheduler(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        push_tasks_resource = True
        white_list = sdk2.parameters.List(
            'Test Whitelist',
                default=[
                'YABS_SERVER_40_FT_BS_A_B', 'YABS_SERVER_40_FT_BS_SAMPLED',
                'YABS_SERVER_40_FT_YABS_SAMPLED',
                'YABS_SERVER_40_FT_BSRANK_A_B',
                'YABS_SERVER_40_FT_BSRANK_SAMPLED',
                'YABS_SERVER_40_FT_YABS_A_B', 'YABS_SERVER_38_BASE_SIZE_A',
                'YABS_SERVER_38_BASE_SIZE_A_SAMPLED', 'YABS_SERVER_38_BASE_SIZE_B',
                'YABS_SERVER_38_BASE_SIZE_COMMON', 'YABS_SERVER_38_BASE_SIZE_COMMON_SAMPLED',
                'YABS_SERVER_22_CS_VERSIONS_DIFF', 'YABS_SERVER_40_FT_META_BS_A_B_SAMPLED',
                'YABS_SERVER_40_FT_META_BSRANK_A_B_SAMPLED', 'YABS_SERVER_40_FT_META_YABS_A_B_SAMPLED'
            ])
        with sdk2.parameters.Group('TestEnv parameters') as auth_parameters:
            testenv_project = sdk2.parameters.String('Testenv project', default='yabs-2.0')
            testenv_token = sdk2.parameters.YavSecret("Yav secret", default="sec-01d6apzcex5fpzs5fcw1pxsfd5")
        config = sdk2.parameters.JSON(
            'Data to find required resources',
                default={
                'YABS_SERVER_.*_FT_BS_.*': {'resource_type': 'YABS_FT_SMART_META_REPORT', 'find_key': {'meta_mode': 'bs'}},
                'YABS_SERVER_.*_FT_YABS_.*': {'resource_type': 'YABS_FT_SMART_META_REPORT', 'find_key': {'meta_mode': 'yabs'}},
                'YABS_SERVER_.*_FT_BSRANK_.*': {'resource_type': 'YABS_FT_SMART_META_REPORT', 'find_key': {'meta_mode': 'bsrank'}},
                'YABS_SERVER_.*_BASE_SIZE_A': {'resource_type': 'YABS_DB_SMART_META_REPORT', 'find_key': {'shard_key': 'A'}},
                'YABS_SERVER_.*_BASE_SIZE_A_SAMPLED': {'resource_type': 'YABS_DB_SMART_META_REPORT', 'find_key': {'shard_key': 'A'}},
                'YABS_SERVER_.*_BASE_SIZE_B': {'resource_type': 'YABS_DB_SMART_META_REPORT', 'find_key': {'shard_key': 'B'}},
                'YABS_SERVER_.*_BASE_SIZE_C': {'resource_type': 'YABS_DB_SMART_META_REPORT', 'find_key': {'shard_key': 'C'}},
                'YABS_SERVER_.*_BASE_SIZE_COMMON': {'resource_type': 'YABS_DB_SMART_META_REPORT', 'find_key': {'shard_key': 'COMMON'}},
                'YABS_SERVER_.*_BASE_SIZE_COMMON_SAMPLED': {'resource_type': 'YABS_DB_SMART_META_REPORT', 'find_key': {'shard_key': 'COMMON'}},
                'TEST_DIFF_.*': {'resource_type': 'COMPARE_DIFF_TEST_RESOURCE', 'find_key': {}},
            })
        jobs_json = sdk2.parameters.JSON(
            'Which jobs should be started for diff in key-job',
                default={
                "YABS_SERVER_22_CS_VERSIONS_DIFF": [
                    "YABS_SERVER_38_BASE_SIZE_A",
                    "YABS_SERVER_38_BASE_SIZE_A_SAMPLED",
                    "YABS_SERVER_38_BASE_SIZE_B",
                    "YABS_SERVER_38_BASE_SIZE_COMMON",
                    "YABS_SERVER_38_BASE_SIZE_COMMON_SAMPLED"
                    ]
            })

    class Context(sdk2.Context):
        checked_jobs = {}

    def on_execute(self):
        with self.memoize_stage.resource_check(commit_on_entrance=False, max_runs=3):
            self.check_resources()
        with self.memoize_stage.start_helpers:
            self.start_helper_sub_tasks()
        with self.memoize_stage.wait_sub_tasks:
            wait_dict = {bin_search_help_sub_task: 'report' for bin_search_help_sub_task in self.Context.checked_jobs.values()}
            raise sdk2.WaitOutput(wait_dict, wait_all=True, timeout=360)
        for job in self.Context.checked_jobs:
            binary_search_helper_report = "Result of the {} \n".format(get_task_html_hyperlink(self.Context.checked_jobs[job])) + \
            YabsBinarySearchHelper[self.Context.checked_jobs[job]].Parameters.report
            self.set_info(binary_search_helper_report, do_escape=False)

    def check_resources(self):
        testenv_resources = TEClient.get_resources(self.Parameters.testenv_project)
        if any([testenv_resource['status']=='SWITCHING' for testenv_resource in testenv_resources]):
            raise TaskFailure("Resource switching")

    def start_helper_sub_tasks(self):
        testenv_token = self.Parameters.testenv_token.data()["testenv_token"]
        testenv_api_client = TestenvApiClient(token=testenv_token)
        for job in self.Parameters.white_list:
            if job not in self.Context.checked_jobs:
                self.set_info(job)
                for key in self.Parameters.config.keys():
                    if re.match(key, job):
                        job_settings = self.Parameters.config[key].copy()
                        if not self.Parameters.config[key]['find_key']:
                            job_settings['find_key'] = {'test_name': job}
                        break
                job_info = testenv_api_client['projects'][self.Parameters.testenv_project]['jobs'][job].GET()
                binary_search_helper_task = YabsBinarySearchHelper(
                    self,
                    description="Help from task {}".format(get_task_html_hyperlink(self.id)),
                    owner=self.owner,
                    pre_revision=job_info['last_revision'][u'revision'],
                    test_revision=0,
                    find_key=job_settings['find_key'],
                    testenv_project=self.Parameters.testenv_project,
                    test_name=job,
                    diff_resource_type=job_settings['resource_type'],
                    hidden=True,
                    jobs_json=self.Parameters.jobs_json
                )
                binary_search_helper_task.enqueue()
                self.set_info("Run binary search helper. Task {}".format(get_task_html_hyperlink(binary_search_helper_task.id)), do_escape=False)
                self.Context.checked_jobs[job] = binary_search_helper_task.id
