from collections import defaultdict
from datetime import datetime

import jinja2

import pytz


TEMPLATE = """
<!DOCTYPE html>
<html>
    <head>
        <title>Flame Graph report</title>
        <style>
            .internal-list {
                display: flex;
                flex-basis: 0;
                flex-wrap: wrap;
                flex: 1 1 0px;
                justify-content: center;
                margin-left: 5%;
                margin-right: 5%;
                vertical-align: top;
            }
            .role-content {
                display: flex;
                flex-wrap: wrap;
                flex-basis: 50%;
                justify-content: center;
            }
            .break {
                flex-basis: 100%;
                height: 0;
            }
            .role-container {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
            }
        </style>
    </head>

    <body>
        <h2>{{ end_time }}</h2>
        <div class="role-container">
            {% for role in ('Partner', 'Search', 'SSP', 'Rank', 'Total') %}
            {% if role in configs %}
            {% set c1 = configs[role] %}
            <div class="role-content">
                <h3>{{ role }}</h3>
                <div class="break"></div>
                {% for program in ('meta', 'stat', 'None') %}
                {% if program in c1 %}
                {% set c2 = c1[program] %}
                <div class="internal-list">
                    {% if program != "None" %}
                    <h4>{{ program }}</h4>
                    {% endif %}
                    <div class="break"></div>
                    <ul>
                        {% for mode in ('base', 'diff') %}
                            {% if mode in c2 %}
                                {% set c3 = c2[mode] %}
                                {% for duration, c4 in c3.iteritems() %}
                                    <li><a href="{{ c4['None']['False']['url'] }}">{{ mode }}/ {{ duration }}</a>
                                    {% for pmatch_fails, c5 in c4.iteritems() %}
                                        {% for is_mirror, c6 in c5.iteritems() %}
                                            {% set text = '' %}
                                            {% if pmatch_fails != 'None' %}{% set text = text + ' bad pmatch' %}{% endif %}
                                            {% if is_mirror == 'True' %}{% set text = text + ' mirror' %}{% endif %}
                                            {% if text != '' %}
                                                (<a href="{{ c6['url'] }}">{{ text.strip() }}</a>)
                                            {% endif %}
                                        {% endfor %}
                                    {% endfor %}
                                    </li>
                                {% endfor %}
                            {% endif %}
                        {% endfor %}
                    </ul>
                </div>
                {% endif %}
                {% endfor %}
            </div>
            <div class="break"></div>
            {% endif %}
            {% endfor %}
        </div>
</body></html>
"""


def get_html_report(end_time, configs):
    end_dt = datetime.utcfromtimestamp(end_time)
    local_end_dt = end_dt.replace(tzinfo=pytz.utc).astimezone(pytz.timezone('Europe/Moscow')).strftime('%Y-%m-%d %H:%M:%S')

    dict_configs = defaultdict(lambda: defaultdict(lambda: defaultdict(lambda: defaultdict(lambda: defaultdict(dict)))))
    for k, config in configs.iteritems():
        if 'url' not in config:
            continue

        (role, program, mode, duration, pmatch_fails, is_mirror) = k.split(';')
        dict_configs[role][program][mode][int(int(duration) / 60 / 60)][pmatch_fails][is_mirror] = config

    return jinja2.Template(TEMPLATE).render(end_time=local_end_dt, configs=dict_configs)
