from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.common.rest import Client
from sandbox.common import errors
from sandbox import sdk2
import logging


logger = logging.getLogger(__name__)

DEFAULT_PARAMS = {
    'build_system': 'ya',
    'build_type': 'release',
    'ya_yt_store': True,
    'ya_yt_proxy': 'hahn.yt.yandex.net',
    'ya_yt_dir': '//home/yabs-cs-sandbox/build-cache',
    'ya_yt_token_vault_owner': 'YABS_SERVER_SANDBOX_TESTS',
    'ya_yt_token_vault_name': 'yabscs_yt_token',
    'ya_yt_put': True,
    'ya_yt_store_threads': 32,
    'ya_yt_store_codec': 'zstd08_1',
    'ya_yt_store_refresh_on_read': True,
    'ya_yt_replace_result': True,
    '__requirements__': {'client_tags': 'LINUX'}
}

TAR_TARGETS_WITH_FLAGS = [
    'yabs/server/tools/config/cloud',
    'yabs/server/tools/debug_cookie',
    'yabs/server/tools/chkdb',
    'contrib/libs/llvm12/tools/llvm-symbolizer'
]

TAR_TARGETS_WITHOUT_FLAGS = ['yabs/server/daemons/bs_static']

YT_TARGETS_WITH_FLAGS = ['yabs/server/cs/packages/yabs-cs', 'yql/tools/mrjob']


class YabsCacheHeaterScheduler(sdk2.Task):
    '''Heat last green revision and two last releases'''
    class Parameters(sdk2.Task.Parameters):
        component_name = sdk2.parameters.String('Release machine component name', default='yabs_server')
        scheduler_id = sdk2.parameters.Integer('Last good revision scheduler id', default=12674)
        versions_count = sdk2.parameters.Integer('Count of versions to heat', default=2)
        with sdk2.parameters.Output:
            arcadia_urls = sdk2.parameters.String('')

    def on_execute(self):
        from release_machine.release_machine.services.release_engine.services.Model import ModelClient
        from release_machine.release_machine.proto.structures import message_pb2

        scheduler = Client().scheduler[self.Parameters.scheduler_id].read()
        task = sdk2.Task[scheduler['task']['last']['id']]
        with self.memoize_stage.wait_scheduler:
            raise sdk2.WaitOutput({task.id: "good_or_stable_revision"}, wait_all=True)
        rm_model_client = ModelClient.from_address(rm_const.Urls.RM_HOST)
        if scheduler['status'] == 'STOPPED':
            raise errors.TaskFailure('Scheduler stopped')

        logging.debug('Get last revision from task {}'.format(task.id))
        arcadia_urls = []
        arcadia_urls.append('arcadia:/arc/trunk/arcadia@{}'.format(task.Parameters.good_or_stable_revision))
        scope_data = rm_model_client.get_scopes(
            message_pb2.ScopesRequest(
                component_name=self.Parameters.component_name,
                start_scope_number=0,
                limit=self.Parameters.versions_count,
            ),
        )
        if not scope_data:
            self.set_info("No scopes for component")
        for branch_scope in scope_data.branch_scopes:
            path = 'arcadia:/{}/arcadia@{}'.format(branch_scope.tags[0].arcadia_path, branch_scope.tags[0].first_commit_id)
            arcadia_urls.append(path)
        for tag, targets in (('YT_TARGETS_WITH_FLAGS', YT_TARGETS_WITH_FLAGS), ('TAR_TARGETS_WITH_FLAGS', TAR_TARGETS_WITH_FLAGS), ('TAR_TARGETS_WITHOUT_FLAGS', TAR_TARGETS_WITHOUT_FLAGS)):
            for arcadia_url in arcadia_urls:
                task = YaMake2(
                    self,
                    description='Heat arc revision {}'.format(arcadia_url),
                    checkout_arcadia_from_url=arcadia_url,
                    targets=';'.join(targets),
                    tags=[tag],
                    thinlto=True if tag == 'TAR_TARGETS_WITHOUT_FLAGS' else False,
                    **DEFAULT_PARAMS
                )
                task.save().enqueue()
        self.Parameters.arcadia_urls = arcadia_urls
