from sandbox import sdk2
import subprocess


class YabsDashboardsGenerator(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 2048
        disk_space = 2048

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        baseage_binary = sdk2.parameters.Resource('Baseage binary file')

    def on_execute(self):
        baseage_binary = str(sdk2.ResourceData(self.Parameters.baseage_binary).path)
        subprocess.Popen([baseage_binary, "--grafana-token", sdk2.Vault.data('yabs_solo_token')]).wait()
