from datetime import datetime, timedelta
from os.path import join as join_path, realpath, dirname
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

import logging
import os


class YabsRtgraphFill(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        day = sdk2.parameters.String("Date yyyy-mm-dd", default='', required=False)
        yql_token_vault_name = sdk2.parameters.String("YQL Token vault name", default="YQL_TOKEN", required=True)
        db = sdk2.parameters.String("YT cluster", default="hahn", required=True)
        handlers_path = sdk2.parameters.String("Handlers path", default="//home/yabs-rtgraph/rtgraph_handlers", required=True)
        execution_space = 2 * 1024
        required_ram = 1 * 1024

    def on_execute(self):
        logging.info("Started!")
        self.yql_token = sdk2.task.Vault.data(self.author, self.Parameters.yql_token_vault_name)

        yql_path = "{}/yql".format(os.getcwd())

        logging.info("Get yql client")
        with sdk2.helpers.ProcessLog(self, logger="curl") as pl:
            sp.Popen(
                'curl -Lo {} https://yql.yandex.net/download/cli/linux/yql && chmod +x {}'.format(
                    yql_path,
                    yql_path
                ),
                shell=True,
                stdout=pl.stdout,
                stderr=sp.STDOUT,
            ).wait()

        script_path = join_path(dirname(realpath(__file__)), 'fill.py')

        day = self.Parameters.day if self.Parameters.day else (
            datetime.now() - timedelta(hours=24)
        ).strftime('%Y-%m-%d')

        with sdk2.helpers.ProcessLog(self, logger="fill") as pl:
            sp.Popen(
                '{} python {} -- --day="{}" --token={} --cluster={} --handlers_path={}'.format(
                    yql_path,
                    script_path,
                    day,
                    self.yql_token,
                    self.Parameters.db,
                    self.Parameters.handlers_path
                ),
                shell=True,
                stdout=pl.stdout,
                stderr=sp.STDOUT,
            ).wait()

        logging.info("Done!")
