import sys, time, argparse

from yql.api.v1.client import YqlClient


def run_query_and_wait(client, query):
    query = client.query(query)
    query.run()

    while True:
        print 'Status:', query.results.json['status']
        if query.results.json['status'] in ['COMPLETED', 'ABORTED', 'ERROR']:
            break
        time.sleep(10)

    if query.results.json['status'] != 'COMPLETED':
        sys.exit(8)


def main():
    pars = argparse.ArgumentParser(description="Run yql query")
    pars.add_argument("--day", "-d", help="Query")
    pars.add_argument("--token", "-t", help="Token")
    pars.add_argument("--cluster", "-c", help="Cluster")
    pars.add_argument("--handlers_path", help="Handlers path")
    opts = pars.parse_args()

    day = opts.day
    db = opts.cluster
    token = opts.token
    handlers_path = opts.handlers_path

    client = YqlClient(db=db, token=token)

    run_query_and_wait(client,
        """
           PRAGMA yt.InferSchema;
           insert into [//tmp/danila/rtgraph_handlers] with truncate select distinct Handler as handler from [//home/logfeller/logs/bs-proto-accessstat-log/1d/{day}];
        """.format(day=day)
    )

    run_query_and_wait(client,
        """
           PRAGMA yt.InferSchema;
           insert into [{handlers_path}] with truncate select * from [//tmp/danila/rtgraph_handlers];
        """.format(handlers_path=handlers_path)
    )


main()
