from sandbox.projects.yabs.audit.runtime.monitoring.requirements import (
    IssueAcceptedRequirement, IssueQueueRequirement, IssueTypeRequirement, IssueAcceptedNotByAuthorRequirement
)


def check_new_runtime_requirements(startrek_client, issue_key, logger=None):
    audit_requirements = (
        IssueQueueRequirement(('BSNEWRUNTIME',)),
        IssueAcceptedRequirement(),
        IssueTypeRequirement(('releaseServer',)),
        IssueAcceptedNotByAuthorRequirement(2),
    )
    issue = startrek_client.issues[issue_key]
    if not issue:
        return "Cannot find issue [{}] associated with release".format(issue_key)
    errors = []
    for requirement in audit_requirements:
        result, error = requirement.check(issue=issue)
        if logger:
            logger.debug("Checking requirement {} -> result={}, error={}".format(requirement, result, error))
        if not result:
            errors.append(error)
    return len(errors) == 0, errors
