import logging
logger = logging.getLogger('YabsServerDeployOnNewRuntime::StartrekHelper')
logging.basicConfig(level=logging.INFO)


class StartrekHelper:
    def __init__(self, st_client, queue='BSNEWRUNTIME', task_type='releaseServer'):
        self.st_client = st_client
        self.queue = queue
        self.task_type = task_type

    def create_issue(self, author, assignee, summary, description):
        try:
            logger.info("Creating issue")
            issue = self.st_client.issues.create(
                queue=self.queue,
                type=self.task_type,
                author=author,
                assignee=assignee,
                summary=summary,
                description=description,
                tags=['BsNewRuntime']
            )
        except Exception as e:
            logger.warn('Failed creating issue with %s: %s', type(e), e)
            return None
        else:
            logger.info('Created issue %s', issue.key)
            return issue

    def comment(self, issue_key, text, summonees=None):
        issue = self.st_client.issues[issue_key]
        if not issue:
            logger.error("Can not find issue by key %s", issue_key)
            return
        comment = issue.comments.create(
            params=dict(notify=True),
            text=text,
            summonees=summonees,
            # maillistSummonees=maillist_summonees
        )
        logger.info("Comment added to issue [%s]: %s", issue_key, comment)
