import argparse
import json

from yql.api.v1.client import YqlClient


def run(db, token, query):
    client = YqlClient(db=db, token=token)
    query = client.query(query, syntax_version=1)
    query.run()

    if not query.results.is_success:
        raise Exception('\n'.join([str(err) for err in query.results.errors]))

    result = []
    for table in query.get_results():
        table.fetch_full_data()

        columns = []
        for column_name, column_type in table.columns:
            columns.append(column_name)

        for row in table.rows:
            result.append(dict([(columns[i], value) for i, value in enumerate(row)]))
    return result


def main():
    pars = argparse.ArgumentParser(description="Run yql query")
    pars.add_argument("--query", "-q", help="Query")
    pars.add_argument("--token", "-t", help="Token")
    pars.add_argument("--db", "-d", help="Cluster")
    opts = pars.parse_args()
    return run(opts.db, opts.token, opts.query)


if __name__ == '__main__':
    print(json.dumps(main(), indent=2, sort_keys=True))
