from sandbox import sdk2
import sandbox.projects.resource_types as rt
import sandbox.common.types.resource as ctr

from sandbox.sdk2.helpers import subprocess as sp


class YabsIncidentsChartBin(rt.ARCADIA_PROJECT):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["evor"]
    release_subscribers = ["evor"]


class YabsIncidentsChart(sdk2.Task):
    """Task that collects incident and money data"""

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 2048
        disk_space = 2048

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.String("Time period of statistics", multiline=True) as timeperiod:
            timeperiod.values.year_over_year = timeperiod.Value(default=True)
            timeperiod.values.half_over_half = None
            timeperiod.values.half_over_year = None
            timeperiod.values.half_over_year_without_small = None
        binary_id = sdk2.parameters.LastReleasedResource(
            'Incident loss calculator binary',
            resource_type=YabsIncidentsChartBin,
            state=(ctr.State.READY, ),
            required=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        env = {
            'ARTMON_TOKEN': sdk2.Vault.data('yabs-artmon-incident-token'),
            'SOLOMON_TOKEN': sdk2.Vault.data('robot-yabsmon-solomon-token')
        }
        cmd = [
            str(bin_res.path),
            '--timeperiod={0}'.format(self.Parameters.timeperiod),
        ]
        with sdk2.helpers.ProcessLog(self, logger="incident_mon_log") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
