# -*- coding: utf-8 -*-

import sandbox.common.types.notification as ctn
import time

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.resource_types import YASAP_PDB_PHANTOMJS_PACKAGE


class YabsAlertsChartImage(sdk2.Resource):
    pass


FETCH_IMAGE_CODE = """
var webPage = require('webpage');
var page = webPage.create();
var system = require('system');

if (system.args.length <= 2) {
    console.log("Provide url to render from");
    phantom.exit(1);
}

var url = system.args[1];
var result_file = system.args[2];
var user = system.env["ARTMON_USER"];
var password = system.env["ARTMON_PASSWORD"];
var credentials = "login=" + user + "&passwd=" + password;

page.open("https://passport.yandex-team.ru/auth", "POST", credentials, function () {
    console.log("Done passport");
    var new_page = webPage.create();
    new_page.viewportSize = { width: 1920, height: 1080 };
    new_page.navigationLocked = false;
    new_page.open(url, function (status) {
        new_page.evaluate(function() {
            document.body.bgColor = 'white';
        });
        function sleep(ms) {
            ms += new Date().getTime();
            while (new Date() < ms){}
        }
        sleep(10000);
        console.log("Done artmon " + status);
        new_page.render(result_file, {format: 'png', quality: '100'});
        phantom.exit();
    });
});
"""


class YabsAlertsMakeReport(sdk2.Task):
    """
        Task to create report after alert triggered
    """
    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Charts"):
            data_url = sdk2.parameters.String(
                "Url to fetch the data with",
                default='https://artmon.bsadm.yandex-team.ru/public_api/fetch_artmon_data.cgi?module=Traffic2&period_start=2016-10-26&period_start_hour=00&period_end=2016-10-26&period_end_hour=23&compare_enabled=0&compare_start=2016-10-19&compare_start_hour=00&compare_end=2016-10-19&compare_end_hour=23&timegroup=min&periodicity=undefined&query=%7B"filters"%3A%7B"YandexFilter"%3A"context_net_rtb"%2C"OrderFilter"%3A"commerce"%2C"TypeFilter"%3A"all"%2C"ContextFilter"%3A"0"%2C"UserFilter"%3A"all"%2C"detailed"%3A0%2C"Slice"%3A"orders"%2C"relative"%3A0%2C"bsistat_traffic"%3A0%2C"bspstat_traffic"%3A0%2C"fast_traffic"%3A0%2C"clickhouse"%3A1%2C"not_only_good"%3A0%2C"discount"%3A0%2C"add_charts"%3A1%2C"logarithm_axis"%3A0%2C"fraction_series"%3A1%2C"fraction_series_shift"%3A1%2C"fraud_series"%3A0%7D%7D&series=%5B"clicks.clickhouse"%5D&from=-864000s&until=-0s&format=raw&noCache=True',  # NOQA
            )
            time_to = sdk2.parameters.Integer(
                "End of the period (timestamp)",
                default=time.time(),
            )
            period = sdk2.parameters.Integer(
                "Period in seconds",
                default=60 * 60 * 24 * 2,
            )
            shift = sdk2.parameters.Integer(
                "Compare with the same <> seconds ago",
                default=60 * 60 * 24 * 7,
            )

        with sdk2.parameters.Group("Credentials"):
            artmon_user = sdk2.parameters.String(
                "User to access artmon",
                default="robot-yabs-artmon",
            )
            artmon_password_vault = sdk2.parameters.String(
                "Artmon password vault name",
                default="password",
            )

        with sdk2.parameters.Group("Binaries"):
            phantomjs_resource = sdk2.parameters.Resource(
                "Resource with PhantomJS binary",
                resource_type=YASAP_PDB_PHANTOMJS_PACKAGE,
                default_value=538961905,
            )

    def on_execute(self):
        images = YabsAlertsChartImage(self, "Charts resource", "charts")
        images_path = sdk2.ResourceData(images).path
        images_path.mkdir(0o755)

        images_link = "https://proxy.sandbox.yandex-team.ru/{resource_id}".format(resource_id=images.id)

        html_result = ["<h1><b>Run, you tools</b></h1>"]

        artmon_fetcher_path = self.save_js_script()
        phantomjs_path = sdk2.ResourceData(self.Parameters.phantomjs_resource).path
        with sdk2.helpers.ProcessLog(self, "phantomjs") as pl:
            filename = "{name}.png".format(name="report")
            sp.check_call(
                [str(phantomjs_path), str(artmon_fetcher_path), self.Parameters.data_url, str(images_path / filename)],
                stdout=pl.stdout,
                stderr=sp.STDOUT,
                env={
                    "ARTMON_USER": self.Parameters.artmon_user,
                    "ARTMON_PASSWORD": sdk2.Vault.data(self.Parameters.artmon_password_vault),
                },
            )

        image_link = "{images_link}/{filename}".format(images_link=images_link, filename=filename)
        html_result.append("<img src=\"{image_link}\">".format(image_link=image_link))

        self.server.notification(
            subject="It's ALIVE!",
            body="<br>".join(html_result),
            recipients=["snusmumrik", "kochurovvs"],
            transport=ctn.Transport.EMAIL,
            type=ctn.Type.HTML,
            task_id=self.id,
            view=ctn.View.DEFAULT,
        )

    def save_js_script(self):
        code = FETCH_IMAGE_CODE
        code_path = self.path("artmon_fetcher.js")
        code_path.write_bytes(code)
        return code_path
