from parameters import ApphostSUTParameters
from sandbox import sdk2
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.yabs.apphost.sut import ApphostSUT
from sandbox.projects.yabs.apphost.sut.adapters.interface import ApphostSUTAdapterInterface


class ApphostSUTSandboxAdapter(ApphostSUTAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return ApphostSUTParameters

    def get_apphost_port(self):
        return self.parameters.apphost_port

    def get_apphost_vertical(self):
        return self.parameters.vertical

    def get_apphost_mode(self):
        return self.parameters.apphost_mode

    def get_arcadia_revision(self):
        return self.parameters.arcadia_revision

    def get_tokens(self):
        owner = self.task_instance.owner
        return {
            'SANDBOX_AUTH_TOKEN': sdk2.Vault.data(owner, self.parameters.sandbox_token_vault_name),
            'YA_TOKEN': sdk2.Vault.data(owner, self.parameters.ya_token_vault_name),
            'YT_TOKEN': sdk2.Vault.data(owner, self.parameters.yt_token_vault_name),
        }

    def create_module(self):
        return ApphostSUT(self)
