from sandbox import sdk2


DEFAULT_PORT = 10090


class ApphostSUTParameters(sdk2.Task.Parameters):
    apphost_port = sdk2.parameters.Integer('Port for apphost', default_value=DEFAULT_PORT)
    apphost_mode = sdk2.parameters.String(
        "Apphost mode (agent or arcadia)",
        default='agent',
    )
    arcadia_revision = sdk2.parameters.String(
        "Arcadia revision for apphost (trunk or svn revision)",
        default='trunk',
    )
    vertical = sdk2.parameters.String(
        "Apphost vertical",
        required=True,
    )

    ya_token_vault_name = sdk2.parameters.String(
        "YA token vault name",
        default='ssr_tests_ya_token',
    )
    yt_token_vault_name = sdk2.parameters.String(
        "YT token vault name",
        default='ssr_tests_yt_token',
    )
    sandbox_token_vault_name = sdk2.parameters.String(
        "Sandbox token vault name",
        default='ssr_tests_sandbox_token',
    )
