import os

from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase
from sandbox.projects.yabs.apphost.sut import ApphostSUT
from sandbox.projects.yabs.apphost.sut.adapters.interface import ApphostSUTAdapterInterface


class ApphostSUTStandaloneAdapter(ApphostSUTAdapterInterface, StandaloneAdapterBase):
    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache', work_dir='work_dir', base_dir='base_dir'):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir, resource_cache_dir)

    def get_apphost_port(self):
        return self.parameters.apphost_port

    def get_apphost_vertical(self):
        return self.parameters.vertical

    def get_tokens(self):
        sandbox_token = os.environ.get('SANDBOX_AUTH_TOKEN')
        ya_token = os.environ.get('YA_TOKEN')
        yt_token = os.environ.get('YT_TOKEN')
        if sandbox_token is None:
            raise RuntimeError("Sandbox token is not found. Please set the environment variable 'SANDBOX_AUTH_TOKEN'")
        if ya_token is None:
            raise RuntimeError("Ya token is not found. Please set the environment variable 'YA_TOKEN'")
        if yt_token is None:
            raise RuntimeError("Yt token is not found. Please set the environment variable 'YT_TOKEN'")
        return {
            'SANDBOX_AUTH_TOKEN': sandbox_token,
            'YA_TOKEN': ya_token,
            'YT_TOKEN': yt_token,
        }

    def get_apphost_mode(self):
        return self.parameters.apphost_mode

    def get_arcadia_revision(self):
        return self.parameters.arcadia_revision

    def create_module(self):
        return ApphostSUT(self)
