# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.projects.yabs.base_bin_task import BaseBinTask
from sandbox.projects.yabs.artmon.b2b.lib.artmon_b2b_lib import TrafficBackToBack


class ArtmonQueryList(sdk2.Resource):
    pass


class ArtmonBackToBack(BaseBinTask):

    class Parameters(BaseBinTask.Parameters):
        with sdk2.parameters.String('First module', default='Traffic2') as first_module:
            for module in ['Traffic2', 'Traffic3']:
                first_module.values[module] = module
        with sdk2.parameters.String('First module type', default='pre-prod') as first_module_type:
            for module_type in ['pre-prod', 'prod']:
                first_module_type.values[module_type] = module_type
        with sdk2.parameters.String('Second module', default='Traffic3') as second_module:
            for module in ['Traffic2', 'Traffic3']:
                second_module.values[module] = module
        with sdk2.parameters.String('Second module type', default='pre-prod') as second_module_type:
            for module_type in ['pre-prod', 'prod']:
                second_module_type.values[module_type] = module_type
        ticket = sdk2.parameters.String(
            'ticket',
            default='BSRELEASE-3957',
            required=True
        )
        repetitions_number = sdk2.parameters.Integer(
            'number of repetitions',
            default=2,
            required=True
        )
        time_difference_threshold = sdk2.parameters.Float(
            'allowable time difference threshold',
            default=0.3,
            required=True
        )
        startrek_token = sdk2.parameters.String(
            'startrek token',
            default='ROBOT_ARTMON_ST_TOKEN',
            required=True
        )
        artmon_token = sdk2.parameters.String(
            'artmon oauth token',
            default='ARTMON_OAUTH_TOKEN',
            required=True
        )
        startrek_url = sdk2.parameters.String(
            'startrek url',
            default='https://st-api.yandex-team.ru',
            required=True
        )
        user = sdk2.parameters.String(
            'user',
            default='robot-yabs-artmon',
            required=True
        )
        resource_name = sdk2.parameters.String(
            'resource name',
            default='ARTMON_QUERY_LIST',
            required=True
        )
        artmon_url = sdk2.parameters.String(
            'artmon url',
            default='https://artmon.bsadm.yandex-team.ru/',
            required=True
        )

    def on_execute(self):
        from startrek_client import Startrek

        logging.info('Task started')
        startrek = Startrek(
            useragent='artmon',
            base_url=self.Parameters.startrek_url,
            token=sdk2.Vault.data(self.owner, self.Parameters.startrek_token)
        )
        traffic_b2b = TrafficBackToBack(
            sdk2.Vault.data(self.owner, self.Parameters.artmon_token),
            self.Parameters.time_difference_threshold,
            self.Parameters.artmon_url,
            self.Parameters.resource_name,
            self.Parameters.repetitions_number
        )
        first = (self.Parameters.first_module, self.Parameters.first_module_type)
        second = (self.Parameters.second_module, self.Parameters.second_module_type)
        text = traffic_b2b.b2b(first, second)
        text.insert(0, '**{}** vs **{}**'.format(
            '{} {}'.format(self.Parameters.first_module, self.Parameters.first_module_type),
            '{} {}'.format(self.Parameters.second_module, self.Parameters.second_module_type)
        ))
        issue = startrek.issues[self.Parameters.ticket]
        issue.comments.create(text=''.join(text))
