import datetime
import json

import sandbox.common.types.task as ctt
from sandbox import sdk2
from sandbox import common

from sandbox.projects.yabs.audit.lib import BaseAuditBinTask, Args


class YabsAudit(BaseAuditBinTask):
    """Task That Represents Single Entity"""
    class Parameters(BaseAuditBinTask.Parameters):
        kill_timeout = 21600
        task = sdk2.parameters.JSON(
            label="Task to launch",
            required=True,
        )

    class Requirements(BaseAuditBinTask.Requirements):
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='yabs_audit')
            ]
        )

    def set_task_logs_attributes(self, task):
        from yabs.stat.yabs_yt_audit.lib import find_audit_class_by_name

        audit_class = find_audit_class_by_name(task.get('name'))
        ttl = audit_class.get_logs_ttl()
        if ttl is not None:
            self.log_resource.ttl = ttl

        self.log_resource.audit_name = task.get('name')
        self.log_resource.start_date = datetime.date.fromtimestamp(task.get('start_time')).isoformat()
        self.log_resource.end_date = datetime.date.fromtimestamp(task.get('end_time')).isoformat()
        self.log_resource.iteration = 8 - task.get('divergence_count', 3) - task.get('fail_count', 5)

    def on_execute(self):
        from yabs.stat.yabs_yt_audit.lib import execute
        from yabs.stat.yabs_yt_audit.task import Task

        args = Args(self.Parameters)
        task = self.Parameters.task
        if 'keys' in task:
            task['keys'] = json.dumps(task['keys'])

        self.set_task_logs_attributes(task)

        status = execute(args, Task(**task), self.id)
        if status == 1:
            raise common.errors.TaskError("Exception during binary execution")
        elif status == 2:
            raise common.errors.TaskFailure("Divergence")
