from sandbox import sdk2
from sandbox.projects.yabs.base_bin_task import BaseBinTask


class BaseAuditBinTask(BaseBinTask):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 4096
        disk_space = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(BaseBinTask.Parameters):
        with BaseBinTask.Parameters.version_and_task_resource() as version_and_task_resource:
            resource_attrs = sdk2.parameters.Dict("Filter resource by", default={"name": "YabsYtAudit"})

        yt_proxy = sdk2.parameters.String(
            label="proxy for storing routine's metadata",
            default="ZENO",
            required=True,
        )

        yt_path_prefix = sdk2.parameters.String(
            label="YT path prefix",
            default="//home/yabs/stat/",
            required=True,
        )

        queue_table_name = sdk2.parameters.String(
            label="Queue table name",
            default="AuditQueue",
            required=True,
        )

        history_table_name = sdk2.parameters.String(
            label="History table name",
            default="AuditHistory",
            required=True,
        )

        yt_token_secret_id = sdk2.parameters.YavSecret(
            label="YT token secret id",
            required=True,
            description='secret should contain keys: YT_TOKEN',
        )

        yql_token_secret_id = sdk2.parameters.YavSecret(
            label="YQL token secret id",
            required=True,
            description='secret should contain keys: yt_token',
        )

        ch_host = sdk2.parameters.String(
            label="Clickhouse host",
            required=True,
        )

        ch_port = sdk2.parameters.Integer(
            label="Clickhouse port",
            default=9000,
            required=True,
        )

        ch_scheme = sdk2.parameters.String(
            label="Clickhouse network scheme (http/https)",
            default="http",
            required=True,
        )

        ch_user = sdk2.parameters.String(
            label="Clickhouse user",
            default="remote",
            required=True,
        )

        ch_password_secret_id = sdk2.parameters.YavSecret(
            label="Clickhouse password secret id",
            required=False,
            description='secret should contain keys: clickhouse_pwd',
        )

        ch_db = sdk2.parameters.String(
            label="Default Clickhouse database",
            default="stat",
            required=True,
        )

        ch_secure = sdk2.parameters.Bool(
            label="Use secure Clickhouse connection",
            default=False,
        )


class Args(object):
    debug = False

    def __init__(self, parameters):

        self.yql_token = parameters.yql_token_secret_id.data()["yt_token"]
        self.yt_token = parameters.yt_token_secret_id.data()["YT_TOKEN"]

        self.startrek_token = ""
        if getattr(parameters, "startrek_token_secret_id", None):
            self.startrek_token = parameters.startrek_token_secret_id.data()["startrek_token"]
        if getattr(parameters, "abc_token_secret_id", None):
            self.abc_token = parameters.abc_token_secret_id.data()["abc_token"]
        if getattr(parameters, "solomon_token_secret_id", None):
            self.solomon_token = parameters.solomon_token_secret_id.data()["solomon_token"]
        self.ch_password = ""
        if parameters.ch_password_secret_id:
            self.ch_password = parameters.ch_password_secret_id.data()["clickhouse_pwd"]
        self.parameters = parameters

    def __getattr__(self, name):
        return getattr(self.parameters, name)
