from .requirements import (
    IssueQueueRequirement, IssueTypeRequirement, IssueAcceptedRequirement, BuildTaskTypeRequirement,
    BuildTaskReleasedRequirement, ApproversCountRequirement
)

COMPONENT_NAME = 'yabs_server'
BUILD_TASK_TYPES = ('BUILD_YABS_SERVER',)
RESOURCE_TYPE = 'BS_RELEASE_TAR'
AUDITABLE_BINARIES = (
    "yabs-server",
    "yabs-server-cloud",
)
AUDIT_REQUIREMENTS = (
    IssueQueueRequirement(('BSRELEASE',)),
    IssueTypeRequirement(('releaseServer',)),
    IssueAcceptedRequirement(),
    BuildTaskTypeRequirement(BUILD_TASK_TYPES),
    BuildTaskReleasedRequirement('testing'),
    ApproversCountRequirement(2),
)
