import logging
import re


logger = logging.getLogger(__name__)
BRANCH_PATTERN = re.compile(r'r(?P<release_number>\d+)')


def get_task_releaser(task_id, sandbox_client, release_type):
    audit_info = sandbox_client.task.audit.read(id=task_id)
    # TODO: Remove parsing after SANDBOX-6689
    releasers = []
    releaser_candidate = None
    for audit_record in sorted(audit_info, key=lambda _record: _record['time']):
        if audit_record['status'] == 'RELEASING':
            releaser_candidate = audit_record['author']
            logger.debug('Found attempt to release task by %s', releaser_candidate)
            continue
        if audit_record['status'] == 'RELEASED':
            # Message format from https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/bin/executor.py?blame=true&rev=4716241#L1179
            if audit_record['message'] == "Released as {}".format(release_type) and releaser_candidate is not None:
                logger.debug('Found successfull release to %s by %s', release_type, releaser_candidate)
                releasers.append(releaser_candidate)
            releaser_candidate = None
            continue
    return releasers[-1] if releasers else None


def get_release_number(build_task_id, sandbox_client):
    context = sandbox_client.task[build_task_id].context.read()
    arcadia_url_str = context.get('checkout_arcadia_from_url', '')

    m = BRANCH_PATTERN.search(arcadia_url_str)
    if m is not None:
        return m.groupdict()['release_number']

    parameters = sandbox_client.task[build_task_id].read()["input_parameters"]
    arcadia_url_str = parameters.get('checkout_arcadia_from_url', '')

    m = BRANCH_PATTERN.search(arcadia_url_str)
    if m is not None:
        return m.groupdict()['release_number']

    return None
