import logging

from .sandbox import get_release_number

logger = logging.getLogger(__name__)


def get_release_acceptor(issue):
    for event in issue.changelog.get_all(type='IssueWorkflow'):
        for field in event.fields:
            # TODO:Review: Do we REALLY need this exact transaction? Or we can just leave requirement for target state?
            try:
                if field['field'].id == 'status' and field['from'].key == 'needAcceptance' and field['to'].key == 'readyToDeploy':
                    return event.updatedBy.id
            except KeyError:
                pass
    return None


def get_release_requester(issue):
    for event in issue.changelog.get_all(type='IssueWorkflow'):
        for field in event.fields:
            try:
                if field['field'].id == 'status' and field['to'].key == 'needAcceptance':
                    return event.updatedBy.id
            except KeyError:
                pass
    return None


def get_release_issue(task_id, sandbox_client, startrek_helper, component_info):
    release_number = get_release_number(task_id, sandbox_client)
    try:
        return startrek_helper.find_ticket_by_release_number(release_number, component_info)
    except Exception as exc:
        logger.error(exc)
        return None
